import { string } from 'alga-js'
import strapiHelper from "../../../../../utils/strapiHelper"

export default defineEventHandler(async (event) => {
  let data: any = {}
  const body = await readBody(event)
  const id = getRouterParam(event, 'id')

  try {
    const res: any = await strapiHelper(event, `m-products/${id}`, 'PUT', {
      data: {
        Main_Image: body.imageId
      }
    })
    if(res) {
      data = res
    }
  } catch(error: any) {
    data = {
      status: error.status || error.statusCode || 500,
      message: error.detail || error.message || error.statusMessage
    }
  }

  return data
})